/*
THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES INC. ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE
DISCLAIMED. IN NO EVENT SHALL ANALOG DEVICES INC. BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

YOU ASSUME ANY AND ALL RISK FROM THE USE OF THIS CODE OR SUPPORT FILE.

IT IS THE RESPONSIBILITY OF THE PERSON INTEGRATING THIS CODE INTO AN APPLICATION
TO ENSURE THAT THE RESULTING APPLICATION PERFORMS AS REQUIRED AND IS SAFE.

    Module       : bsp.c
    Description  : Board Support Package for EVAL-ADuCRF101EBZ
    Date         : 10 June 2010
    Version      : v1.00
    Changelog    : v1.00 Initial

*/

#include <include.h>

//*****************************************************************************
// Function    : BSP_Initialisation
// Description : Initialisation for the EVAL-ADuCRF101EBZ
//*****************************************************************************
boolean BSP_Initialisation(void)
{
   boolean              bOk            = TRUE;

   // Turn off watchdog
   T3CON &= ~T3CON_ENABLE;

   // Port 0
   GP0CON  = GP0CON_CON0_GPIO     | GP0CON_CON1_GPIO     | GP0CON_CON2_GPIO     |
             GP0CON_CON3_GPIOIRQ1 | GP0CON_CON4_ECLKOUT  | GP0CON_CON5_GPIO     |
             GP0CON_CON6_UARTRTS  | GP0CON_CON7_GPIOIRQ3;

   GP0OEN  = GP0OEN_OEN0_IN       |  GP0OEN_OEN1_IN      |  GP0OEN_OEN2_OUT     |
             GP0OEN_OEN3_OUT      |  GP0OEN_OEN4_IN      |  GP0OEN_OEN5_IN      |
             GP0OEN_OEN6_IN       |  GP0OEN_OEN7_OUT;

   // Port 1
   GP1CON  = GP1CON_CON0_UART0RXD | GP1CON_CON1_UART0TXD | GP1CON_CON2_GPIO     |
             GP1CON_CON3_GPIO     | GP1CON_CON4_GPIOIRQ5 | GP1CON_CON5_GPIOIRQ6 |
             GP1CON_CON6_GPIOIRQ7;

   GP1OEN  = GP1OEN_OEN0_IN       |  GP1OEN_OEN1_IN      |  GP1OEN_OEN2_IN      | GP1OEN_OEN3_IN |
             GP1OEN_OEN4_IN       |  GP1OEN_OEN5_IN      |  GP1OEN_OEN6_IN    ;

   // Port 2
   GP2CON = GP2CON_CON0_SPI0MISO  | GP2CON_CON1_SPI0SCLK | GP2CON_CON2_SPI0MOSI |
            GP2CON_CON3_GPIO      | GP2CON_CON4_IRQ8     | GP2CON_CON5_GPIO     |
            GP2CON_CON6_GPIO      | GP2CON_CON7_GPIO;

   GP2OEN  = GP2OEN_OEN0_IN       |  GP2OEN_OEN1_IN      |  GP2OEN_OEN2_IN      |
             GP2OEN_OEN3_OUT      |  GP2OEN_OEN4_IN      |  GP2OEN_OEN5_IN      |
             GP2OEN_OEN6_IN       |  GP2OEN_OEN7_IN;

   // Port 3
   GP3CON = GP3CON_CON0_GPIO      | GP3CON_CON1_GPIO     | GP3CON_CON2_ADIO8    |
            GP3CON_CON3_ADIO9     | GP3CON_CON4_GPIO     | GP3CON_CON5_ADIO11   |
            GP3CON_CON6_GPIO      | GP3CON_CON7_GPIO;
                                  
   GP3OEN  = GP3OEN_OEN0_IN       |  GP3OEN_OEN1_IN      |  GP3OEN_OEN2_IN      |
             GP3OEN_OEN3_IN       |  GP3OEN_OEN4_OUT     |  GP3OEN_OEN5_IN      |
             GP3OEN_OEN6_IN       |  GP3OEN_OEN7_IN;

   // Port 4
   // Turn off led
   GP4SET = GP4SET_SET2;
   GP4CON = GP4CON_CON0_ADIO0     | GP4CON_CON1_ADIO1 | GP4CON_CON2_GPIO  |
            GP4CON_CON3_ADIO3     | GP4CON_CON4_ADIO4 | GP4CON_CON5_ADIO5 |
            GP4CON_CON6_ADIO6     | GP4CON_CON7_ADIO7;

   GP4OEN  = GP4OEN_OEN0_IN       |  GP4OEN_OEN1_IN   |  GP4OEN_OEN2_OUT  |
             GP4OEN_OEN3_IN       |  GP4OEN_OEN4_IN   |  GP4OEN_OEN5_IN   |
             GP4OEN_OEN6_IN       |  GP4OEN_OEN7_IN;

   // SPI peripheral configuration
   SPI0DIV                   = ((UCLK/SPI_CLK_FREQ)/2)-0x1;

   // SPI Configuration - Master, interrupt on transmit.
   SPI0CON                   = SPI0CON_MASEN   |    // Master mode
                               SPI0CON_TIM     |    // Interrupt on transmit
                               SPI0CON_TFLUSH  |    // FLush FIFO
                               SPI0CON_RFLUSH  |    // FLush FIFO
                               SPI0CON_ENABLE;

   SPI0CON                   = SPI0CON_MASEN  |    // Master mode
                               SPI0CON_TIM    |    // Interrupt on transmit
                               SPI0CON_ENABLE;

   Urt_Init(UART_BAUD_19200);
   Urt_PinSetup(FALSE); 

   // Configure external interrupts
   EICLR  = EICLR_IRQ5;
   EI1CFG = EI1CFG_IRQ5MDE_RISE | EI1CFG_IRQ5EN;    
   ExtInt_Enable(INT_EXTINT5);
   // We have three bits of priority - set this the lowest level
   ExtInt_SetPriority(INT_EXTINT5,0xFF);

   // Configure external interrupts
   EICLR  = EICLR_IRQ7;
   EI1CFG = EI1CFG_IRQ7MDE_FALL | EI1CFG_IRQ7EN;    
   ExtInt_Enable(INT_EXTINT7);
   // We have three bits of priority - set this the lowest level
   ExtInt_SetPriority(INT_EXTINT7,0xC0);


   // Enable the interrupt from the ADF7023, make it the highest priority interrupt
   EICLR  = EICLR_IRQ8;
   EI2CFG = EI2CFG_IRQ8MDE_HIGHLEVEL | EI2CFG_IRQ8EN;  
   ExtInt_Enable(INT_EXTINT8);
   ExtInt_SetPriority(INT_EXTINT8,0x0);

   return bOk;
}




